/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.system;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.util.ClassList;
import com.ibm.hwmca.fw.util.HThreadGroup;
import com.ibm.hwmca.fw.util.Trace;
import java.util.List;

public class IniFileProcessor {
    public static final short CLASS_EXECUTION_ERROR = 640;
    public static final short INI_FILE_ERROR = 641;
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(85, "IniFileProc");
    private static final String TRACE_MASKT = "XFRMIFPT";
    private static final String TRACE_MASKF = "XFRMIFPF";
    private static final String TRACE_MASKD = "XFRMIFPD";

    public static void runClasses(String controlFile, String threadPrefix) {
        Trace.trace(TRACE_MASKT, "-> IniFileProcessor.runClasses(controlFile=" + controlFile + ",threadPrefix=" + threadPrefix + ")");
        try {
            String path = BaseFileControl.getFilePath(controlFile);
            path = path + controlFile;
            Trace.trace(TRACE_MASKF, "Using INI file " + path + ".");
            List classInfo = ClassList.getClassInfo(path);
            int size = classInfo.size();
            int i = 0;
            while (i < size) {
                ClassList.Info info = (ClassList.Info)classInfo.get(i);
                try {
                    Class<?> cls = Class.forName(info.getClassName());
                    boolean synchronous = info.isSynchronous();
                    Runnable iniClass = (Runnable)cls.newInstance();
                    Trace.trace(TRACE_MASKF, "Running class [" + iniClass.getClass().getName() + ", synchronous=" + synchronous + "].");
                    if (synchronous) {
                        iniClass.run();
                    } else {
                        Thread iniThread = HThreadGroup.defaultThreadGroup().createThread(iniClass, threadPrefix + ":" + cls.getName());
                        iniThread.start();
                    }
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception running class: " + info.getClassName());
                    Trace.trace(TRACE_MASKF, e);
                    new FrameworkLog(logInfo, 640, e).log(FrameworkLogAttributes.INFO_LOG);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception reading control file: " + controlFile);
            Trace.trace(TRACE_MASKF, e);
            new FrameworkLog(logInfo, 641, e).log(FrameworkLogAttributes.INFO_LOG);
        }
        Trace.trace(TRACE_MASKT, "<- IniFileProcessor.runClasses()");
    }
}

